//
//  PXILConversion.h
//  PXImageLib
//
//  Created by Aidas Dailide on 2008-11-17.
//  Copyright 2008 Pixelmator Team Ltd.. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Accelerate/Accelerate.h>


typedef enum PXILReduceBitsTypes
{
	PXILReduceBitsNone,
	PXILReduceBitsStucki,
	PXILReduceBitsFloidSteinberg,
	PXILReduceBitsJJN,
	PXILReduceBitsBayer
} PXILReduceBitsType;

@interface PXILConversion : NSObject {

}
+(PXILConversion *)sharedInstance;
-(BOOL)imageLibConvertARGBtoBGRA:( const vImage_Buffer *)src;
-(BOOL)imageLibAddRandomGaussian:(const vImage_Buffer *)src mean:(int)mean stDev:(int)stDev pSeed:(unsigned int)pSeed;
-(BOOL)imageLibAddRandomGaussianInteger:(const vImage_Buffer *)src mean:(int)mean stDev:(int)stDev pSeed:(unsigned int)pSeed;
-(BOOL)imageLibAddRandomGaussianFloat:(const vImage_Buffer *)src mean:(int)mean stDev:(int)stDev pSeed:(unsigned int)pSeed;
-(BOOL)imageLibReduceBits:( const vImage_Buffer *)dest noise:(int)noise levels:(int)levels reduceType:(PXILReduceBitsType)_type;
@end
