/*
 *  PXOS_Constants.h
 *  PXOpenSave
 *
 *  Created by Rimas Mickevičius on 2008-08-18.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#define PXOS_ErrorDomain	@"PXOpenSaveErrorDomain"

typedef enum _PXOSF_ErrorCodeNames_
{
	ErrorCode_Open_FileNotFound = 10001,
	ErrorCode_Open_FileNotSupported,
	ErrorCode_Open_CouldNotOpen,
	ErrorCode_Open_Fake,
	
	PXOSF_ErrorCode_Open_PSD_BadInput,
	PXOSF_ErrorCode_Open_PSD_16Bits,
	PXOSF_ErrorCode_Open_PSD_UnsupportedColorMode,
	PXOSF_ErrorCode_Open_PSD_ParseError,
	
	PXOSF_ErrorCode_Open_TIFF_BadInput,
	PXOSF_ErrorCode_Open_TIFF_ParseError,
	
	PXOSF_Save_ErrorCode_GenericError,
	PXOSF_ErrorCode_Save_FileNotSupported
} PXOSF_ErrorCodeNames;

#define UTI_PXM		@"com.pixelmator.pxm"
#define UTI_PSD		@"com.adobe.photoshop-image"
#define UTI_RAW		@"public.camera-raw-image"
#define UTI_HTML	(NSString*)kUTTypeHTML
#define UTI_PDF		(NSString*)kUTTypePDF
#define UTI_TIFF	(NSString*)kUTTypeTIFF

#define PXOS_ResolutionType_DotsPerInch			1
#define PXOS_ResolutionType_DotsPerCentimeter	2

#define PXOSF_CurrentPXMversion	202

#define PXOSF_Architecture_Intel	0
#define PXOSF_Architecture_PPC		1

#define PXOSF_Metadata_Key_PXversion			@"_PX_VERSION_"
#define PXOSF_Metadata_Key_LayersSelection		@"_LAYERS_SELECTION_"
#define PXOSF_Metadata_Key_MasksSelection		@"_MASKS_SELECTION_"
#define PXOSF_Metadata_Key_ImageZoom			@"_IMAGE_ZOOM_"
#define PXOSF_Metadata_Key_ImageVisibleRect		@"_IMAGE_VISIBLE_RECT_"
#define PXOSF_Metadata_Key_LayersVisibleRect	@"_LAYERS_VISIBLE_RECT_"
#define PXOSF_Metadata_Key_MasksVisibleRect		@"_MASKS_VISIBLE_RECT_"
#define PXOSF_Metadata_Key_ICCprofileName		@"_ICC_PROFILE_NAME_"
#define PXOSF_Metadata_Key_PrintInfo			@"_PRINT_INFO_"
#define	PXOSF_Metadata_Key_DocWindowRect		@"_DOCUMENT_WINDOW_RECT_"
#define PXOSF_Metadata_Key_Slices @"_DOCUMENT_SLICES_"
#define PXOSF_Metadata_Key_SlicesInfo @"_DOCUMENT_SLICES_INFO_"
#define PXOSF_Metadata_Key_LastSliceInfo @"_DOCUMENT_LAST_SLICE_INFO_"
#define PXOSF_Metadata_Key_OriginalEXIF			@"_ORIGINAL_EXIF_"

/// compresionai
// 0 - none - gryni pixeliai
// 1 - zlibo compressionas

typedef enum _PXOSF_PXM_Compressions_
	{
		PXOSF_PXM_Compression_None = 0,
		PXOSF_PXM_Compression_zLib,
	} PXOSF_PXM_Compressions;

#define _usesPixelsEncoding	PXOSF_PXM_Compression_zLib
