//
//  PXOS_FileManager.h
//  PXOpenSave
//
//  Created by Rimas Mickevičius on 2008-08-18.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "PXOS_Protocols.h"
#import "PXOS_Constants.h"

@class PXOS_FileOpenManager;
@class PXOS_FileSaveManager;

@interface PXOS_FileManager : NSObject
{
	@private
		id <PXOS_OpenSaveDelegate> _delegate;
		
		PXOS_FileOpenManager *_openManager;
		PXOS_FileSaveManager *_saveManager;
	
		const char *_magickFileType; 
	
	//----------
		id <PXOS_QuickOpenProtocol> _quickOpenDelegate;
}

//------------

-(id)initQuickOpenWithDelegate:(id<PXOS_QuickOpenProtocol>)delegate;
-(id<PXOS_QuickOpenProtocol>)quickDelegate;
-(NSError*)QuickOpenImageAtPath:(NSURL*)fileURL withDestinationCGColorSpace:(CGColorSpaceRef)destColorSapce;

//------------



-(id)initWithDelegate:(id<PXOS_OpenSaveDelegate>)delegate;
-(id<PXOS_OpenSaveDelegate>)delegate;
-(void)cleanupOpenSaveManagers;

//// ATIDARYMAS ///////

-(NSError*)openFileAtURL:(NSURL*)fileURL;
-(NSURL*)getOpenURL;
-(void)abortLoading;
-(NSError*)PXOSF_Open_PDF_OpenPageAtIndex:(unsigned int)pIndex;

///// SAUGOJIMAS /////////

-(NSError*)saveFileToURL:(NSURL*)fileURL ofUTI:(NSString*)newFileUTI magickType:(const char*)magickType;
-(NSURL*)getSaveURL;
-(const char*)getMagickType;
-(void)setMagickType:(const char*)mType;


-(NSError*)PXOSF_ResaveImageAtURL:(NSURL*)sourceURL toURL:(NSURL*)destinationURL;

-(NSDictionary*)PXOSF_PXM_MetadataForFIleAtURL:(NSURL*)fileURL;


//---- exportui ------
-(NSError*)getFileSizeFor_UTI:(NSString*)fUTI mType:(const char*)mType fileSize:(size_t*)fSize;



// reik paduot failo path. jei iskart grazina NO, kazkas negerai.
-(BOOL)openFileAtPath:(NSString*)filePath;

@end
